/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.arsenal.entity;

import dev.doctor4t.arsenal.index.ArsenalDamageTypes;
import dev.doctor4t.arsenal.index.ArsenalEnchantments;
import dev.doctor4t.arsenal.index.ArsenalEntities;
import dev.doctor4t.arsenal.index.ArsenalItems;
import dev.doctor4t.arsenal.index.ArsenalParticles;
import dev.doctor4t.arsenal.index.ArsenalSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

public class AnchorbladeEntity
extends class_1665 {
    private static final class_2940<Byte> ANCHOR_FLAGS = class_2945.method_12791(AnchorbladeEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(AnchorbladeEntity.class, (class_2941)class_2943.field_13322);
    public int returnTimer;

    public AnchorbladeEntity(class_1299<? extends AnchorbladeEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public AnchorbladeEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(ArsenalEntities.ANCHORBLADE, owner, world);
        this.setItem(stack.method_7972());
        this.method_5875(true);
        this.setReeling(class_1890.method_8225((class_1887)ArsenalEnchantments.REELING, (class_1799)stack) > 0);
    }

    public void setItem(class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8449) || stack.method_7985()) {
            this.method_5841().method_12778(ITEM, (Object)stack.method_46651(1));
        }
    }

    private class_1799 getTrackedItem() {
        return (class_1799)this.method_5841().method_12789(ITEM);
    }

    public class_1799 getStack() {
        class_1799 itemStack = this.getTrackedItem();
        return itemStack.method_7960() ? new class_1799((class_1935)class_1802.field_8449) : itemStack;
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(ANCHOR_FLAGS, (Object)0);
        this.method_5841().method_12784(ITEM, (Object)class_1799.field_8037);
    }

    public void method_5773() {
        class_1297 owner = this.method_24921();
        double d = 2.0;
        if (!this.method_37908().field_9236) {
            if (owner == null || !owner.method_5805()) {
                this.method_31472();
                return;
            }
            if (this.hasDealtDamage() || this.method_7441()) {
                this.method_7433(true);
                class_243 vec3d = owner.method_33571().method_1020(this.method_19538());
                if (this.method_37908().field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double length = vec3d.method_1033();
                this.method_18799(vec3d.method_1029().method_1021(Math.min(length, d * 3.0)));
            }
            if (this.method_19538().method_1022(owner.method_19538()) > 30.0) {
                this.setDealtDamage(true);
            }
        }
        if (this.field_7588 && !this.hasDealtDamage()) {
            if (this.hasReeling()) {
                if (this.returnTimer++ > 100) {
                    this.setDealtDamage(true);
                }
                if (owner == null) {
                    this.setDealtDamage(true);
                    return;
                }
                float e = (float)(d / 5.0);
                class_243 vec3d = this.method_19538().method_1020(owner.method_33571());
                owner.method_18799(owner.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021((double)e)));
                owner.field_6017 = 0.0f;
            } else {
                float radius = 5.0f;
                this.method_37908().method_8406((class_2394)ArsenalParticles.SHOCKWAVE, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                for (class_1309 hitLivingEntity : this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014((double)radius), class_1309::method_5805)) {
                    float strength = this.getKnockbackForEntity(hitLivingEntity);
                    if ((double)strength <= 0.0) continue;
                    this.field_6007 = true;
                    class_243 distance = hitLivingEntity.method_19538().method_1031(0.0, (double)(hitLivingEntity.method_17682() / 2.0f), 0.0).method_1020(this.method_19538());
                    class_243 footDistance = hitLivingEntity.method_19538().method_1020(this.method_19538());
                    if (footDistance.field_1351 > distance.field_1351) {
                        distance = footDistance;
                    }
                    float proximity = (float)class_3532.method_16436((double)class_3532.method_15350((double)(distance.method_1033() / (double)radius), (double)0.0, (double)1.0), (double)1.0, (double)0.0);
                    class_243 direction = distance.method_1029().method_1021((double)(proximity * strength));
                    hitLivingEntity.method_5762(direction.field_1352, direction.field_1351, direction.field_1350);
                    hitLivingEntity.field_6017 = 0.0f;
                }
                this.setDealtDamage(true);
            }
        }
        super.method_5773();
    }

    public void method_36457(float pitch) {
        if (!this.hasDealtDamage()) {
            super.method_36457(pitch);
        }
    }

    public void method_36456(float yaw) {
        if (!this.hasDealtDamage()) {
            super.method_36456(yaw);
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 hitEntity = entityHitResult.method_17782();
        float damage = 10.0f;
        if (hitEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)hitEntity;
            damage += class_1890.method_8218((class_1799)this.getTrackedItem(), (class_1310)livingEntity.method_6046());
        }
        class_1297 owner = this.method_24921();
        this.setDealtDamage(true);
        class_3414 soundEvent = this.method_7440();
        hitEntity.field_6008 = 0;
        if (hitEntity.method_5643(this.method_37908().method_48963().method_48797(ArsenalDamageTypes.ANCHOR, (class_1297)this, this.method_24921()), damage)) {
            class_1657 player;
            class_1297 class_12972;
            if (hitEntity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (hitEntity instanceof class_1309) {
                class_1309 hitLivingEntity = (class_1309)hitEntity;
                if (owner instanceof class_1309) {
                    class_1890.method_8210((class_1309)hitLivingEntity, (class_1297)owner);
                    class_1890.method_8213((class_1309)((class_1309)owner), (class_1297)hitLivingEntity);
                    float strength = this.getKnockbackForEntity(hitLivingEntity);
                    if (!((double)strength <= 0.0)) {
                        this.field_6007 = true;
                        class_243 dir = hitLivingEntity.method_19538().method_1020(owner.method_19538()).method_1029().method_1021((double)strength);
                        if (this.hasReeling()) {
                            dir = owner.method_19538().method_1020(hitLivingEntity.method_19538()).method_1021((double)(strength / 10.0f));
                        }
                        hitLivingEntity.method_5762(dir.field_1352, dir.field_1351, dir.field_1350);
                    }
                }
                this.method_7450(hitLivingEntity);
            }
            if ((class_12972 = this.method_24921()) instanceof class_1657 && !(player = (class_1657)class_12972).method_7337()) {
                player.method_7357().method_7906(ArsenalItems.ANCHORBLADE, 40);
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783(soundEvent, 1.0f, 1.0f);
    }

    private float getKnockbackForEntity(class_1309 hitLivingEntity) {
        return (float)(1.0 * (1.0 - hitLivingEntity.method_26825(class_5134.field_23718)));
    }

    protected boolean method_34713(class_1657 player) {
        return this.method_34714((class_1297)player);
    }

    protected float method_7436() {
        return 0.99f;
    }

    protected class_3414 method_7440() {
        return ArsenalSounds.ENTITY_ANCHORBLADE_LAND;
    }

    protected class_1799 method_7445() {
        return class_1799.field_8037;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public boolean hasDealtDamage() {
        return this.getAnchorFlag(0);
    }

    public void setDealtDamage(boolean dealtDamage) {
        this.setAnchorFlag(0, dealtDamage);
    }

    public boolean hasReeling() {
        return this.getAnchorFlag(1);
    }

    public void setReeling(boolean reeling) {
        this.setAnchorFlag(1, reeling);
    }

    public boolean isRecalled() {
        return this.getAnchorFlag(2);
    }

    public void setRecalled(boolean recalled) {
        if (recalled) {
            this.setDealtDamage(true);
        }
        this.setAnchorFlag(2, recalled);
    }

    private boolean getAnchorFlag(int flag) {
        if (flag < 0 || flag > 8) {
            return false;
        }
        return ((Byte)this.field_6011.method_12789(ANCHOR_FLAGS) >> flag & 1) == 1;
    }

    private void setAnchorFlag(int flag, boolean value) {
        if (flag < 0 || flag > 8) {
            return;
        }
        if (value) {
            this.field_6011.method_12778(ANCHOR_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ANCHOR_FLAGS) | 1 << flag)));
        } else {
            this.field_6011.method_12778(ANCHOR_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ANCHOR_FLAGS) & ~(1 << flag))));
        }
    }
}

